/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture;

import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.blakebr0.mysticalagriculture.api.MysticalAgricultureConfigValues;
import com.blakebr0.mysticalagriculture.client.EssenceVesselColorManager;
import com.blakebr0.mysticalagriculture.client.ModClientExtensions;
import com.blakebr0.mysticalagriculture.client.ModClientTooltipComponentFactories;
import com.blakebr0.mysticalagriculture.client.ModMenuScreens;
import com.blakebr0.mysticalagriculture.client.ModRecipeBookCategories;
import com.blakebr0.mysticalagriculture.client.ModTESRs;
import com.blakebr0.mysticalagriculture.client.ModelHandler;
import com.blakebr0.mysticalagriculture.client.handler.AOEAugmentClientHandler;
import com.blakebr0.mysticalagriculture.client.handler.AugmentTooltipHandler;
import com.blakebr0.mysticalagriculture.client.handler.ColorHandler;
import com.blakebr0.mysticalagriculture.client.handler.GuiOverlayHandler;
import com.blakebr0.mysticalagriculture.compat.TOPCompat;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.crafting.DynamicRecipeManager;
import com.blakebr0.mysticalagriculture.data.ModDataGenerators;
import com.blakebr0.mysticalagriculture.handler.AugmentHandler;
import com.blakebr0.mysticalagriculture.handler.ExperienceCapsuleHandler;
import com.blakebr0.mysticalagriculture.handler.MobDropHandler;
import com.blakebr0.mysticalagriculture.handler.MobSoulHandler;
import com.blakebr0.mysticalagriculture.handler.RegisterCapabilityHandler;
import com.blakebr0.mysticalagriculture.handler.TinkerableHandler;
import com.blakebr0.mysticalagriculture.init.ModArmorMaterials;
import com.blakebr0.mysticalagriculture.init.ModBiomeModifiers;
import com.blakebr0.mysticalagriculture.init.ModBlocks;
import com.blakebr0.mysticalagriculture.init.ModConditionSerializers;
import com.blakebr0.mysticalagriculture.init.ModCreativeModeTabs;
import com.blakebr0.mysticalagriculture.init.ModDataComponentTypes;
import com.blakebr0.mysticalagriculture.init.ModIngredientTypes;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.init.ModMenuTypes;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.blakebr0.mysticalagriculture.init.ModTileEntities;
import com.blakebr0.mysticalagriculture.init.ModWorldFeatures;
import com.blakebr0.mysticalagriculture.network.NetworkHandler;
import com.blakebr0.mysticalagriculture.registry.AugmentRegistry;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import com.blakebr0.mysticalagriculture.registry.MobSoulTypeRegistry;
import com.blakebr0.mysticalagriculture.registry.PluginRegistry;
import com.blakebr0.mysticalagriculture.util.RecipeIngredientCache;
import java.lang.reflect.Field;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="mysticalagriculture")
public final class MysticalAgriculture {
    public static final String MOD_ID = "mysticalagriculture";
    public static final String NAME = "Mystical Agriculture";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Mystical Agriculture");

    public MysticalAgriculture(IEventBus bus, ModContainer mod) throws NoSuchFieldException, IllegalAccessException {
        bus.register((Object)this);
        bus.register((Object)new ModBlocks());
        bus.register((Object)new ModItems());
        bus.register((Object)new ModDataGenerators());
        ModArmorMaterials.REGISTRY.register(bus);
        ModCreativeModeTabs.REGISTRY.register(bus);
        ModTileEntities.REGISTRY.register(bus);
        ModDataComponentTypes.REGISTRY.register(bus);
        ModMenuTypes.REGISTRY.register(bus);
        ModIngredientTypes.REGISTRY.register(bus);
        ModConditionSerializers.REGISTRY.register(bus);
        ModRecipeTypes.REGISTRY.register(bus);
        ModRecipeSerializers.REGISTRY.register(bus);
        ModWorldFeatures.REGISTRY.register(bus);
        ModBiomeModifiers.REGISTRY.register(bus);
        bus.register((Object)new NetworkHandler());
        bus.register((Object)new RegisterCapabilityHandler());
        if (FMLEnvironment.dist == Dist.CLIENT) {
            bus.register((Object)new ColorHandler());
            bus.register((Object)new ModelHandler());
            bus.register((Object)new ModTESRs());
            bus.register((Object)new ModRecipeBookCategories());
            bus.register((Object)new ModClientTooltipComponentFactories());
            bus.register((Object)new ModMenuScreens());
            bus.register((Object)new ModClientExtensions());
            bus.register((Object)EssenceVesselColorManager.INSTANCE);
        }
        mod.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)ModConfigs.COMMON, "mysticalagriculture-common.toml");
        MysticalAgriculture.initAPI();
        PluginRegistry.getInstance().loadPlugins();
    }

    @SubscribeEvent
    public void onCommonSetup(FMLCommonSetupEvent event) {
        NeoForge.EVENT_BUS.register((Object)new MobDropHandler());
        NeoForge.EVENT_BUS.register((Object)new MobSoulHandler());
        NeoForge.EVENT_BUS.register((Object)new ExperienceCapsuleHandler());
        NeoForge.EVENT_BUS.register((Object)new AugmentHandler());
        NeoForge.EVENT_BUS.register((Object)new TinkerableHandler());
        NeoForge.EVENT_BUS.register((Object)DynamicRecipeManager.INSTANCE);
        NeoForge.EVENT_BUS.register((Object)RecipeIngredientCache.INSTANCE);
        CropRegistry.getInstance().onCommonSetup();
        AugmentRegistry.getInstance().onCommonSetup();
        MobSoulTypeRegistry.getInstance().onCommonSetup();
    }

    @SubscribeEvent
    public void onClientSetup(FMLClientSetupEvent event) {
        NeoForge.EVENT_BUS.register((Object)new AugmentTooltipHandler());
        NeoForge.EVENT_BUS.register((Object)new GuiOverlayHandler());
        NeoForge.EVENT_BUS.register((Object)new AOEAugmentClientHandler());
        ModelHandler.onClientSetup(event);
    }

    @SubscribeEvent
    public void onInterModEnqueue(InterModEnqueueEvent event) {
        if (ModConfigs.isTheOneProbeInstalled()) {
            TOPCompat.onInterModEnqueue();
        }
    }

    public static ResourceLocation resource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    private static void initAPI() throws NoSuchFieldException, IllegalAccessException {
        Class<MysticalAgricultureAPI> api = MysticalAgricultureAPI.class;
        Field cropRegistry = api.getDeclaredField("cropRegistry");
        Field augmentRegistry = api.getDeclaredField("augmentRegistry");
        Field soulTypeRegistry = api.getDeclaredField("soulTypeRegistry");
        cropRegistry.setAccessible(true);
        cropRegistry.set(null, CropRegistry.getInstance());
        augmentRegistry.setAccessible(true);
        augmentRegistry.set(null, AugmentRegistry.getInstance());
        soulTypeRegistry.setAccessible(true);
        soulTypeRegistry.set(null, MobSoulTypeRegistry.getInstance());
        Field configValues = api.getDeclaredField("configValues");
        configValues.setAccessible(true);
        configValues.set(null, new MysticalAgricultureConfigValues((DoubleSupplier)ModConfigs.INFERIUM_DROP_CHANCE, (DoubleSupplier)ModConfigs.FERTILIZED_ESSENCE_DROP_CHANCE, (BooleanSupplier)ModConfigs.SECONDARY_SEED_DROPS, (BooleanSupplier)ModConfigs.REQUIRES_EFFECTIVE_FARMLAND, (BooleanSupplier)ModConfigs.ENCHANTABLE_SUPREMIUM_TOOLS, (BooleanSupplier)ModConfigs.UNBREAKABLE_SUPREMIUM_ARMOR, (BooleanSupplier)ModConfigs.FAKE_PLAYER_WATERING));
    }
}

